/**
* \file: InputChannel.cpp
*
* \version: $Id:$
*
* \release: $Name:$
*
* Sample input channel implementation for touch
*
* \component: Baidu CarLife
*
* \author: P. Acar / ADIT/ESM / pacar@de.adit-jv.com
*
* \copyright (c) 2017 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#include <adit_logging.h>
#include <bdcl/UspiInputSource.h>

#include "InputChannel.h"

LOG_IMPORT_CONTEXT(tbdcl)

namespace adit { namespace bdcl {

// todo replace raw ptr with smart ptr
InputChannel::InputChannel(CoreCallbackDealer* inCallbackDealer)
{
    mInputSource = new UspiInputSource(this, inCallbackDealer);

    /* no config items to set */

    mInputSource->initialize();
}

InputChannel::~InputChannel()
{
    mInputSource->teardown();
    delete mInputSource;
}

void InputChannel::onError(bdclErrorCodes inErrorCode)
{
    LOG_ERROR((tbdcl, "Error: %d on input channel", static_cast<uint32_t>(inErrorCode)));
}

} } /* namespace adit { namespace bdcl */
